<?php
/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Wp_Tymber_Shop
 * @subpackage Wp_Tymber_Shop/public
 * @author     Tymber <dev@tymber.me>
 */
class Wp_Tymber_Shop_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * The Router Class.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $router;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string $plugin_name       The name of the plugin.
	 * @param      string $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version     = $version;
		$this->api_url     = 'https://api.tymber.io/api/v1';
		$this->store_id    = get_option( '_tymber_storeid_default' );
		$this->api_token   = get_option( '_tymber-api_token' );
	}

	/**
	 * Generate banners shortcode
	 *
	 * @since    1.0.0
	 * @param    array $atts     arguments to shortcode
	 */
	public function tymber_block_banner_shortcode( $atts ) {
		$atts = shortcode_atts(
			array(
				'limit' => '',
				'store' => '',
			),
			$atts
		);

		if ( ! $this->api_token ) {
			return __( 'You need to define a License on Tymber Shop settings.', 'wp-tymber-shop' );
		}

		if ( ! $atts['store'] ) {
			$store_id = $this->store_id;
		} else {
			$store_id = $this->get_store_id( $atts['store'] );
		}

		if ( ! $store_id ) {
			return __( 'A store ID was not specified on Tymber Shop settings.', 'wp-tymber-shop' );
		}

		$banners = $this->get_tymber_banners( $store_id, $atts['limit'] );

		$html = '<style>/*! CSS Used from: Embedded */
		button,div{font-family:Montserrat, sans-serif;}
		.iXQFSq{display:inline-block;vertical-align:middle;overflow:hidden;}
		.iXQFSq{display:inline-block;vertical-align:middle;overflow:hidden;}
		.bFWTwI{min-width:16px;min-height:16px;width:16px;height:16px;color:rgb(0, 0, 0);}
		.bFWTwI{min-width:16px;min-height:16px;width:16px;height:16px;color:rgb(0, 0, 0);}
		.ayAxv{width:auto;}
		@media (min-width: 1024px){
		.ayAxv{display:block;}
		}
		@media (max-width: 1023.98px){
		.ayAxv{display:none;}
		}
		@media (max-width: 767.98px){
		.ayAxv{display:none;}
		}
		.ayAxv{width:auto;}
		@media (min-width: 1024px){
		.ayAxv{display:block;}
		}
		@media (max-width: 1023.98px){
		.ayAxv{display:none;}
		}
		@media (max-width: 767.98px){
		.ayAxv{display:none;}
		}
		.bDSKii{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;}
		.bDSKii > .slide-dot-indicator.slide-dot-indicator__indicator{display:none;}
		.bDSKii > .slide-dot-indicator.slide-dot-indicator__indicator:nth-child(1),.bDSKii > .slide-dot-indicator.slide-dot-indicator__indicator:nth-child(2),.bDSKii > .slide-dot-indicator.slide-dot-indicator__indicator:nth-child(3){display:block;}
		.bDSKii{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;}
		.bDSKii > .slide-dot-indicator.slide-dot-indicator__indicator{display:none;}
		.bDSKii > .slide-dot-indicator.slide-dot-indicator__indicator:nth-child(1),.bDSKii > .slide-dot-indicator.slide-dot-indicator__indicator:nth-child(2),.bDSKii > .slide-dot-indicator.slide-dot-indicator__indicator:nth-child(3){display:block;}
		.jIviUN{width:10px;height:10px;border-radius:5px;margin:5px;background-color:rgb(39, 39, 39);opacity:1;cursor:pointer;}
		.eCjggk{width:10px;height:10px;border-radius:5px;margin:5px;background-color:rgb(39, 39, 39);opacity:0.2;cursor:pointer;}
		.jIviUN{width:10px;height:10px;border-radius:5px;margin:5px;background-color:rgb(39, 39, 39);opacity:1;cursor:pointer;}
		.eCjggk{width:10px;height:10px;border-radius:5px;margin:5px;background-color:rgb(39, 39, 39);opacity:0.2;cursor:pointer;}
		.ddpXyX{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;position:relative;top:0px;bottom:0px;left:50%;z-index:1;border:0px;background-color:rgb(238, 238, 238);transform:rotate(0deg);padding:16px;width:40px;height:40px;border-radius:30px;cursor:pointer;box-shadow:none;}
		.gPSBYw{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;position:relative;top:0px;bottom:0px;right:50%;z-index:1;border:0px;background-color:rgb(238, 238, 238);transform:rotate(180deg);padding:16px;width:40px;height:40px;border-radius:30px;cursor:pointer;box-shadow:none;}
		.ddpXyX{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;position:relative;top:0px;bottom:0px;left:50%;z-index:1;border:0px;background-color:rgb(238, 238, 238);transform:rotate(0deg);padding:16px;width:40px;height:40px;border-radius:30px;cursor:pointer;box-shadow:none;}
		.gPSBYw{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;position:relative;top:0px;bottom:0px;right:50%;z-index:1;border:0px;background-color:rgb(238, 238, 238);transform:rotate(180deg);padding:16px;width:40px;height:40px;border-radius:30px;cursor:pointer;box-shadow:none;}
		.image_slider{background-size:cover;height:100%;cursor:pointer;min-width:100%;max-height:100%;position:absolute;top:0px;left:50%;transform:translate3d(-50%, 0px, 0px);width:auto!important;}
		.flKRIA{background-size:cover;background-image:image-set(url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/35f1289c-15b6-4070-bc7b-2469e363dc9c.jpg?s=bde355a68bbf32caca34ce9e8e70c524&auto=format&fit=crop&ixlib=react-9.0.2&ar=1340%3A180&w=1340&h=180") 1x, url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/35f1289c-15b6-4070-bc7b-2469e363dc9c.jpg?s=bde355a68bbf32caca34ce9e8e70c524&auto=format&fit=crop&ixlib=react-9.0.2&ar=1340%3A180&dpr=2&w=1340&h=180") 2x, url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/35f1289c-15b6-4070-bc7b-2469e363dc9c.jpg?s=bde355a68bbf32caca34ce9e8e70c524&auto=format&fit=crop&ixlib=react-9.0.2&ar=1340%3A180&dpr=3&w=1340&h=180") 3x);height:100%;cursor:pointer;min-width:100%;max-height:100%;position:absolute;top:0px;left:50%;transform:translate3d(-50%, 0px, 0px);width:auto!important;}
		@media (max-width: 1023.98px){
		.flKRIA{background-image:image-set(url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/35f1289c-15b6-4070-bc7b-2469e363dc9c.jpg?s=bde355a68bbf32caca34ce9e8e70c524&auto=format&fit=crop&ixlib=react-9.0.2&ar=1340%3A180&w=1340&h=180") 1x, url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/35f1289c-15b6-4070-bc7b-2469e363dc9c.jpg?s=bde355a68bbf32caca34ce9e8e70c524&auto=format&fit=crop&ixlib=react-9.0.2&ar=1340%3A180&dpr=2&w=1340&h=180") 2x, url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/35f1289c-15b6-4070-bc7b-2469e363dc9c.jpg?s=bde355a68bbf32caca34ce9e8e70c524&auto=format&fit=crop&ixlib=react-9.0.2&ar=1340%3A180&dpr=3&w=1340&h=180") 3x);}
		}
		@media (max-width: 767.98px){
		.flKRIA{background-image:image-set(url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/124b57bf-b65b-41c0-87ac-646d9940f933.jpg?s=01d48bf91d734d67cbe71af397ef9779&auto=format&fit=crop&ixlib=react-9.0.2&ar=767%3A346&w=767&h=346") 1x, url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/124b57bf-b65b-41c0-87ac-646d9940f933.jpg?s=01d48bf91d734d67cbe71af397ef9779&auto=format&fit=crop&ixlib=react-9.0.2&ar=767%3A346&dpr=2&w=767&h=346") 2x, url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/124b57bf-b65b-41c0-87ac-646d9940f933.jpg?s=01d48bf91d734d67cbe71af397ef9779&auto=format&fit=crop&ixlib=react-9.0.2&ar=767%3A346&dpr=3&w=767&h=346") 3x);}
		}
		.lgNrWK{background-size:cover;background-image:image-set(url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/1dcf0922-a04e-4051-afae-92c61a8ae54f.jpg?s=1723b8ae875b4b57418a5fb59f07461a&auto=format&fit=crop&ixlib=react-9.0.2&ar=1340%3A180&w=1340&h=180") 1x, url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/1dcf0922-a04e-4051-afae-92c61a8ae54f.jpg?s=1723b8ae875b4b57418a5fb59f07461a&auto=format&fit=crop&ixlib=react-9.0.2&ar=1340%3A180&dpr=2&w=1340&h=180") 2x, url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/1dcf0922-a04e-4051-afae-92c61a8ae54f.jpg?s=1723b8ae875b4b57418a5fb59f07461a&auto=format&fit=crop&ixlib=react-9.0.2&ar=1340%3A180&dpr=3&w=1340&h=180") 3x);height:100%;cursor:pointer;min-width:100%;max-height:100%;position:absolute;top:0px;left:50%;transform:translate3d(-50%, 0px, 0px);width:auto!important;}
		@media (max-width: 1023.98px){
		.lgNrWK{background-image:image-set(url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/1dcf0922-a04e-4051-afae-92c61a8ae54f.jpg?s=1723b8ae875b4b57418a5fb59f07461a&auto=format&fit=crop&ixlib=react-9.0.2&ar=1340%3A180&w=1340&h=180") 1x, url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/1dcf0922-a04e-4051-afae-92c61a8ae54f.jpg?s=1723b8ae875b4b57418a5fb59f07461a&auto=format&fit=crop&ixlib=react-9.0.2&ar=1340%3A180&dpr=2&w=1340&h=180") 2x, url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/1dcf0922-a04e-4051-afae-92c61a8ae54f.jpg?s=1723b8ae875b4b57418a5fb59f07461a&auto=format&fit=crop&ixlib=react-9.0.2&ar=1340%3A180&dpr=3&w=1340&h=180") 3x);}
		}
		@media (max-width: 767.98px){
		.lgNrWK{background-image:image-set(url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/f6d4827c-8c9c-428a-8d37-b818a4b1c178.jpg?s=8ce48e9c46271ef85e50c80cc664819c&auto=format&fit=crop&ixlib=react-9.0.2&ar=767%3A346&w=767&h=346") 1x, url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/f6d4827c-8c9c-428a-8d37-b818a4b1c178.jpg?s=8ce48e9c46271ef85e50c80cc664819c&auto=format&fit=crop&ixlib=react-9.0.2&ar=767%3A346&dpr=2&w=767&h=346") 2x, url("https://tymber-s3.imgix.net/demo-store-1-12/site/promotional-banners/f6d4827c-8c9c-428a-8d37-b818a4b1c178.jpg?s=8ce48e9c46271ef85e50c80cc664819c&auto=format&fit=crop&ixlib=react-9.0.2&ar=767%3A346&dpr=3&w=767&h=346") 3x);}
		}
		.image_wrapper{position:relative;overflow:hidden;background-color:black;padding-bottom:13.4328%;}
		.image_wrapper:hover{cursor:pointer;}
		@media (max-width: 1023.98px){
		.image_wrapper{padding-bottom:13.4328%;}
		}
		@media (max-width: 767.98px){
		.image_wrapper{padding-bottom:45.1108%;}
		}
		.image_wrapper{position:relative;overflow:hidden;background-color:black;padding-bottom:13.4328%;}
		.image_wrapper:hover{cursor:pointer;}
		@media (max-width: 1023.98px){
		.image_wrapper{padding-bottom:13.4328%;}
		}
		@media (max-width: 767.98px){
		.image_wrapper{padding-bottom:45.1108%;}
		}
		.ieynsD{width:100%;display:block;box-sizing:border-box;max-width:1440px;position:relative;}
		@media (max-width: 1023.98px){
		.ieynsD{padding:0px!important;}
		}
		.ieynsD{width:100%;display:block;box-sizing:border-box;max-width:1440px;position:relative;}
		@media (max-width: 1023.98px){
		.ieynsD{padding:0px!important;}
		}
		.bDUNOu{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;width:100%;padding-top:16px;padding-bottom:16px;background-color:rgb(255, 255, 255);background-image:none;}
		.bDUNOu{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;width:100%;padding-top:16px;padding-bottom:16px;background-color:rgb(255, 255, 255);background-image:none;}
		.btbUzw{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;background-color:rgb(255, 255, 255);border-radius:10px;position:absolute;bottom:4px;left:50%;transform:translate3d(-50%, 0px, 0px);}
		.btbUzw{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;background-color:rgb(255, 255, 255);border-radius:10px;position:absolute;bottom:4px;left:50%;transform:translate3d(-50%, 0px, 0px);}
		.tymber-banner{padding: 8px 32px;}
		.slick-dots li {top: -10px;margin: 1px; padding:0;}
		.slick-dots li button:before {font-size: 10px;line-height: 18px;}
		.slick-dots{background: white;width: auto;border-radius: 20px;position: absolute;bottom: 10%;left: 50%;margin: -25px 0 0 -25px;height: 20px;}
		.slick-slider {position:relative;}
		.slick-prev, .slick-next{background-color: rgb(238, 238, 238) !important;
			width: 40px;
			height: 40px;
			border-radius: 30px;
			cursor: pointer;
			box-shadow: none;
			z-index: 9 !important;
		}
		.tymber-banner.hide_dots .slick-dots, tymber-banner-mobile.hide_dots .slick-dots {
			display: none !important;
		}
		.slick-prev {left: 1% !important;}
		.slick-next {right: 1% !important;}
		.slick-prev:before,.slick-next:before{font-family: inherit !important; color: #000;}
		@media screen and (max-width: 767px) {
			.tymber-banner-mobile {
				display: block !important;
			}
			.tymber-banner {
				display: none !important;
			}
			.slick-dots{
				bottom: 7% !important;
				left: 50% !important;
				margin: 0px 0 0 -70px !important;
			}
		}
		</style>';
		$slides_num = 0;
		if ( $banners->data ) {
			$slides_num = count( $banners->data );
		}

		$hide_dots  = '';
		if ( $slides_num == 1 ) {
			$hide_dots = ' hide_dots';
		}

		$slide_count = 0;

		$html .= '<div class="tymber-banner' . $hide_dots . '" style="width:100%; min-width:100%;">';
			foreach( $banners->data as $banner ) :
				if ( $atts['limit'] && $atts['limit'] == $slide_count ) {
					continue;
				}

				$url = $banner->attributes->destination_url;

				// Generate random key
				$key = $this->generate_random_string( 5 );

				$html .= '<div aria-hidden="true" data-swipeable="true" style="width: 100%; flex-shrink: 0; overflow: auto;">
					<a target="_blank" href="' . $url . '">
						<div class="PromotionalImage__ImageContainer image_wrapper ' . $key . '">
							<div class="PromotionalImage__Image image_slider" style="background-image: url(' . $banner->attributes->desktop_image_url . ')"></div>
						</div>
					</a>
				</div>';

				$slide_count++;

			endforeach;

		$html .= '</div>';

		$slide_count = 0;

		$html .= '<div class="tymber-banner-mobile' . $hide_dots . '" style="width:100%; min-width:100%; display: none;">';
			foreach( $banners->data as $banner ) :
				if ( $atts['limit'] && $atts['limit'] == $slide_count ) {
					continue;
				}
				// Create URL
				$url = wp_make_link_relative( $banner->attributes->destination_url );

				// Generate random key
				$key = $this->generate_random_string( 5 );

				$html .= '<div aria-hidden="true" data-swipeable="true" style="width: 100%; flex-shrink: 0; overflow: auto;">
					<a target="_blank" href="' . $url . '">
						<div class="PromotionalImage__ImageContainer image_wrapper ' . $key . '">
							<div class="PromotionalImage__Image image_slider" style="background-image: url(' . $banner->attributes->mobile_image_url . ')"></div>
						</div>
					</a>
				</div>';

				$slide_count++;

			endforeach;

		$html .= '</div>';

		return $html;
	}

	/**
	 * Generate shortcode
	 *
	 * @since    1.0.0
	 * @param    array $atts     arguments to shortcode
	 */
	public function tymber_block_shortcode( $atts ) {
		$atts = shortcode_atts(
			array(
				'title'  => '',
				'text'   => '',
				'filter' => '',
				'order'  => '',
				'limit'  => '',
				'delivery_type'  => '',
				'store'  => '',
			),
			$atts
		);

		if ( ! $this->api_token ) {
			return __( 'A store ID was not specified on Tymber Shop settings.', 'wp-tymber-shop' );
		}

		if ( ! $atts['store'] ) {
			$store_id = $this->store_id;
		} else {
			$store_id = $this->get_store_id( $atts['store'] );
		}

		$products = $this->get_tymber_data( $store_id, $atts['filter'], $atts['order'], $atts['limit'], $atts['delivery_type'] );

		$shop_url = $this->get_the_shop_url($store_id);

		if ( $atts['filter'] ) {
			$key          = strstr( $atts['filter'], '=', true );
			$query_parts  = explode( '=', $atts['filter'] );
			$value        = explode( ',', $query_parts[1] );
			$view_all     = $shop_url . '?' . $atts['filter'];
		} else {
			$view_all     = $shop_url;
		}
		$view_all = wp_make_link_relative( $view_all );

		$html = '
		<style>
			/*! CSS Used from: Embedded */
			.dQgIel{display:inline-block;vertical-align:middle;overflow:hidden;}
			.dQgIel{display:inline-block;vertical-align:middle;overflow:hidden;}
			.fwUcoW{display:inline-block;vertical-align:middle;overflow:hidden;}
			.fwUcoW{display:inline-block;vertical-align:middle;overflow:hidden;}
			.VKSrw{cursor:default;opacity:1;}
			.VKSrw:hover{opacity:1;}
			.VKSrw:active{opacity:1;filter:brightness(100%);}
			.VKSrw{cursor:default;opacity:1;}
			.VKSrw:hover{opacity:1;}
			.VKSrw:active{opacity:1;filter:brightness(100%);}
			.kuHuRJ{min-width:24px;min-height:24px;width:24px;height:24px;color:rgb(255, 255, 255);cursor:pointer;}
			@media (min-width: 768px){
			.kuHuRJ{display:block;}
			}
			.kuHuRJ{min-width:24px;min-height:24px;width:24px;height:24px;color:rgb(255, 255, 255);cursor:pointer;}
			@media (min-width: 768px){
			.kuHuRJ{display:block;}
			}
			.bUJenD{display:flex;max-width:100%;box-sizing:border-box;gap:4px;}
			.bUJenD > *{margin-right:4px;}
			@media (max-width: 359px){
			.bUJenD{flex-flow:row wrap;}
			}
			.bUJenD{display:flex;max-width:100%;box-sizing:border-box;gap:4px;}
			.bUJenD > *{margin-right:4px;}
			@media (max-width: 359px){
			.bUJenD{flex-flow:row wrap;}
			}
			.ihGa-DG{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;line-height:15px;white-space:nowrap;font-family:sofia-pro, sans-serif;font-weight:400;margin:0px;border:1px solid rgb(235, 235, 235);border-radius:12px;color:rgb(102, 102, 102);letter-spacing:0px;text-transform:uppercase;}
			@media (min-width: 1024px){
			.ihGa-DG{font-size:10px;padding:2px 4px;}
			}
			@media (max-width: 1023.98px){
			.ihGa-DG{font-size:10px;padding:2px 4px;}
			}
			@media (max-width: 767.98px){
			.ihGa-DG{font-size:10px;padding:2px 4px;}
			}
			.ihGa-DG{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;line-height:15px;white-space:nowrap;font-family:sofia-pro, sans-serif;font-weight:400;margin:0px;border:1px solid rgb(235, 235, 235);border-radius:12px;color:rgb(102, 102, 102);letter-spacing:0px;text-transform:uppercase;}
			@media (min-width: 1024px){
			.ihGa-DG{font-size:10px;padding:2px 4px;}
			}
			@media (max-width: 1023.98px){
			.ihGa-DG{font-size:10px;padding:2px 4px;}
			}
			@media (max-width: 767.98px){
			.ihGa-DG{font-size:10px;padding:2px 4px;}
			}
			.cAydmo{letter-spacing:0px;overflow:hidden;text-overflow:ellipsis;}
			@media (max-width: 767.98px){
			.cAydmo{display:inherit;}
			}
			.cAydmo{letter-spacing:0px;overflow:hidden;text-overflow:ellipsis;}
			@media (max-width: 767.98px){
			.cAydmo{display:inherit;}
			}
			.fPuZnD{display:inline-flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;background-color:#e0e0e0;line-height:15px;letter-spacing:0px;white-space:nowrap;text-transform:uppercase;font-family:sans-serif;font-weight:600;padding:2px 4px;border:0px;border-radius:12px;color:rgb(51, 51, 51);max-width:100%;}
			@media (min-width: 1024px){
			.fPuZnD{font-size:8px;}
			}
			@media (max-width: 1023.98px){
			.fPuZnD{font-size:8px;}
			}
			@media (max-width: 767.98px){
			.fPuZnD{font-size:8px;}
			}
			.fPuZnD{display:inline-flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;background-color:#e0e0e0;line-height:15px;letter-spacing:0px;white-space:nowrap;text-transform:uppercase;font-family:sans-serif;font-weight:600;padding:2px 4px;border:0px;border-radius:12px;color:rgb(51, 51, 51);max-width:100%;}
			@media (min-width: 1024px){
			.fPuZnD{font-size:8px;}
			}
			@media (max-width: 1023.98px){
			.fPuZnD{font-size:8px;}
			}
			@media (max-width: 767.98px){
			.fPuZnD{font-size:8px;}
			}
			.fueCwg{position:relative;transition:all 0.5s cubic-bezier(0.25, 0.8, 0.25, 1) 0s;min-height:0px!important;}
			.fueCwg > *{box-sizing:border-box;width:100%;}
			@media (min-width: 1024px){
			.fueCwg{min-width:150px;max-width:280px;}
			}
			@media (max-width: 1023.98px){
			.fueCwg{min-width:150px;max-width:25vw;}
			}
			@media (max-width: 767.98px){
			.fueCwg{min-width:130px;max-width:50vw;}
			}
			@media (min-width: 768px){
			.fueCwg:hover{transform:scale(1);}
			}
			.fueCwg{position:relative;transition:all 0.5s cubic-bezier(0.25, 0.8, 0.25, 1) 0s;min-height:0px!important;}
			.fueCwg > *{box-sizing:border-box;width:100%;}
			@media (min-width: 1024px){
			.fueCwg{min-width:150px;max-width:280px;}
			}
			@media (max-width: 1023.98px){
			.fueCwg{min-width:150px;max-width:25vw;}
			}
			@media (max-width: 767.98px){
			.fueCwg{min-width:130px;max-width:50vw;}
			}
			@media (min-width: 768px){
			.fueCwg:hover{transform:scale(1);}
			}
			.lnODeW{box-sizing:border-box;overflow:hidden;position:relative;transition:all 0.5s cubic-bezier(0.25, 0.8, 0.25, 1) 0s;background-color:white;margin-top:0px;opacity:1;border:0px;border-radius:10px;font-family:sofia-pro, sans-serif;display:flex;flex-direction:column;box-shadow:rgba(0, 0, 0, 0.2) 0px 0px 10px -3px!important;}
			@media (min-width: 1024px){
			.lnODeW{height:380px;}
			}
			@media (max-width: 1023.98px){
			.lnODeW{height:350px;}
			}
			@media (max-width: 767.98px){
			.lnODeW{height:350px;}
			}
			@media (min-width: 768px){
			.lnODeW:hover{transform:scale(1.05);box-shadow:none;border:0px;}
			}
			.lnODeW{box-sizing:border-box;overflow:hidden;position:relative;transition:all 0.5s cubic-bezier(0.25, 0.8, 0.25, 1) 0s;background-color:white;margin-top:0px;opacity:1;border:0px;border-radius:10px;font-family:sofia-pro, sans-serif;display:flex;flex-direction:column;box-shadow:rgba(0, 0, 0, 0.2) 0px 0px 10px -3px!important;}
			@media (min-width: 1024px){
			.lnODeW{height:380px;}
			}
			@media (max-width: 1023.98px){
			.lnODeW{height:350px;}
			}
			@media (max-width: 767.98px){
			.lnODeW{height:350px;}
			}
			@media (min-width: 768px){
			.lnODeW:hover{transform:scale(1.05);box-shadow:none;border:0px;}
			}
			.neoAm{height:auto;padding-bottom:0px!important;}
			@media (min-width: 1024px){
			.neoAm{padding:0px;}
			}
			@media (max-width: 1023.98px){
			.neoAm{padding:0px;}
			}
			@media (max-width: 767.98px){
			.neoAm{padding:0px;}
			}
			.neoAm > a{display:flex;position:relative;}
			.neoAm{height:auto;padding-bottom:0px!important;}
			@media (min-width: 1024px){
			.neoAm{padding:0px;}
			}
			@media (max-width: 1023.98px){
			.neoAm{padding:0px;}
			}
			@media (max-width: 767.98px){
			.neoAm{padding:0px;}
			}
			.neoAm > a{display:flex;position:relative;}
			.bNgEec{width:100%;object-fit:contain;border-radius:4px;border-bottom:1px solid rgb(248, 248, 248);}
			@media (min-width: 1024px){
			.bNgEec{height:175px;}
			}
			@media (max-width: 1023.98px){
			.bNgEec{height:175px;}
			}
			@media (max-width: 767.98px){
			.bNgEec{height:175px;}
			}
			.bNgEec{width:100%;object-fit:contain;border-radius:4px;border-bottom:1px solid rgb(248, 248, 248);}
			@media (min-width: 1024px){
			.bNgEec{height:175px;}
			}
			@media (max-width: 1023.98px){
			.bNgEec{height:175px;}
			}
			@media (max-width: 767.98px){
			.bNgEec{height:175px;}
			}
			.CSvot{display:flex;flex-direction:column;padding-bottom:0px!important;}
			.CSvot > a{text-decoration:none;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;}
			@media (min-width: 1024px){
			.CSvot{padding:8px 0px 0px;}
			.CSvot > *{margin-bottom:4px;}
			}
			@media (max-width: 1023.98px){
			.CSvot{padding:8px 0px 0px;}
			.CSvot > *{margin-bottom:4px;}
			}
			@media (max-width: 767.98px){
			.CSvot{padding:8px 0px 0px;}
			.CSvot > *{margin-bottom:4px;}
			}
			.CSvot{display:flex;flex-direction:column;padding-bottom:0px!important;}
			.CSvot > a{text-decoration:none;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;}
			@media (min-width: 1024px){
			.CSvot{padding:8px 0px 0px;}
			.CSvot > *{margin-bottom:4px;}
			}
			@media (max-width: 1023.98px){
			.CSvot{padding:8px 0px 0px;}
			.CSvot > *{margin-bottom:4px;}
			}
			@media (max-width: 767.98px){
			.CSvot{padding:8px 0px 0px;}
			.CSvot > *{margin-bottom:4px;}
			}
			@media (min-width: 1024px){
			.fytMEJ{padding:0px 0px 8px;}
			}
			@media (max-width: 1023.98px){
			.fytMEJ{padding:0px 0px 8px;}
			}
			@media (max-width: 767.98px){
			.fytMEJ{padding:0px 0px 8px;}
			}
			@media (min-width: 1024px){
			.fytMEJ{padding:0px 0px 8px;}
			}
			@media (max-width: 1023.98px){
			.fytMEJ{padding:0px 0px 8px;}
			}
			@media (max-width: 767.98px){
			.fytMEJ{padding:0px 0px 8px;}
			}
			.bJVrMZ{flex:1 1 0%;display:flex;flex-direction:column;-webkit-box-pack:justify;justify-content:space-between;padding:0px 8px;}
			.bJVrMZ{flex:1 1 0%;display:flex;flex-direction:column;-webkit-box-pack:justify;justify-content:space-between;padding:0px 8px;}
			.lloAGz{cursor:pointer;-webkit-line-clamp:1;overflow:hidden;display:-webkit-box;white-space:normal;-webkit-box-orient:vertical;font-weight:400;font-family:sofia-pro, sans-serif;color:rgb(51, 51, 51);line-height:1.4;text-transform:none;}
			.lloAGz:hover{text-decoration:underline;}
			@media (min-width: 1024px){
			.lloAGz{font-size:14px;}
			}
			@media (max-width: 1023.98px){
			.lloAGz{font-size:14px;}
			}
			@media (max-width: 767.98px){
			.lloAGz{font-size:14px;}
			}
			.lloAGz{cursor:pointer;-webkit-line-clamp:1;overflow:hidden;display:-webkit-box;white-space:normal;-webkit-box-orient:vertical;font-weight:400;font-family:sofia-pro, sans-serif;color:rgb(51, 51, 51);line-height:1.4;text-transform:none;}
			.lloAGz:hover{text-decoration:underline;}
			@media (min-width: 1024px){
			.lloAGz{font-size:14px;}
			}
			@media (max-width: 1023.98px){
			.lloAGz{font-size:14px;}
			}
			@media (max-width: 767.98px){
			.lloAGz{font-size:14px;}
			}
			.gMJRj{display:flex;-webkit-box-pack:justify;justify-content:space-between;-webkit-box-align:center;align-items:center;}
			.gMJRj{display:flex;-webkit-box-pack:justify;justify-content:space-between;-webkit-box-align:center;align-items:center;}
			.kRdiPk{letter-spacing:1px;text-transform:uppercase;cursor:pointer;font-weight:600;font-family:sofia-pro, sans-serif;color:rgb(102, 102, 102);}
			.kRdiPk:hover{text-decoration:underline;}
			@media (min-width: 1024px){
			.kRdiPk{font-size:10px;}
			}
			@media (max-width: 1023.98px){
			.kRdiPk{font-size:10px;}
			}
			@media (max-width: 767.98px){
			.kRdiPk{font-size:10px;}
			}
			.kRdiPk{letter-spacing:1px;text-transform:uppercase;cursor:pointer;font-weight:600;font-family:sofia-pro, sans-serif;color:rgb(102, 102, 102);}
			.kRdiPk:hover{text-decoration:underline;}
			@media (min-width: 1024px){
			.kRdiPk{font-size:10px;}
			}
			@media (max-width: 1023.98px){
			.kRdiPk{font-size:10px;}
			}
			@media (max-width: 767.98px){
			.kRdiPk{font-size:10px;}
			}
			.dbOBBq{display:block;white-space:nowrap;text-overflow:ellipsis;overflow:hidden;font-family:sofia-pro, sans-serif;font-weight:400;color:rgb(114, 114, 114);}
			@media (min-width: 1024px){
			.dbOBBq{font-size:12px;}
			}
			@media (max-width: 1023.98px){
			.dbOBBq{font-size:12px;}
			}
			@media (max-width: 767.98px){
			.dbOBBq{font-size:12px;}
			}
			.dbOBBq{display:block;white-space:nowrap;text-overflow:ellipsis;overflow:hidden;font-family:sofia-pro, sans-serif;font-weight:400;color:rgb(114, 114, 114);}
			@media (min-width: 1024px){
			.dbOBBq{font-size:12px;}
			}
			@media (max-width: 1023.98px){
			.dbOBBq{font-size:12px;}
			}
			@media (max-width: 767.98px){
			.dbOBBq{font-size:12px;}
			}
			.kJrSSp{position:absolute;top:8px;left:8px;}
			.kJrSSp{position:absolute;top:8px;left:8px;}
			.bHmBtJ{display:flex;-webkit-box-align:center;align-items:center;}
			.bHmBtJ{display:flex;-webkit-box-align:center;align-items:center;}
			.xzbAw{box-sizing:border-box;background-color:#212121;box-shadow:none;display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;border-radius:40px;cursor:pointer;padding:0px;color:rgb(255, 255, 255);font-weight:400;transition:width 0.3s ease 0s;}
			@media (min-width: 1024px){
			.xzbAw{height:36px;width:36px;}
			}
			@media (max-width: 1023.98px){
			.xzbAw{height:36px;width:36px;}
			}
			@media (max-width: 767.98px){
			.xzbAw{height:36px;width:36px;}
			}
			.xzbAw{box-sizing:border-box;#212121;box-shadow:none;display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;border-radius:40px;cursor:pointer;padding:0px;color:rgb(255, 255, 255);font-weight:400;transition:width 0.3s ease 0s;}
			@media (min-width: 1024px){
			.xzbAw{height:36px;width:36px;}
			}
			@media (max-width: 1023.98px){
			.xzbAw{height:36px;width:36px;}
			}
			@media (max-width: 767.98px){
			.xzbAw{height:36px;width:36px;}
			}
			.guCiog{display:flex;-webkit-box-pack:justify;justify-content:space-between;font-family:sofia-pro, sans-serif;font-weight:700;}
			@media (min-width: 1024px){
			.guCiog{font-size:14px;flex-direction:column;direction:ltr;align-items:flex-start;}
			}
			@media (max-width: 1023.98px){
			.guCiog{font-size:14px;flex-direction:column;direction:ltr;align-items:flex-start;}
			}
			@media (max-width: 767.98px){
			.guCiog{font-size:14px;flex-direction:column;direction:ltr;align-items:flex-start;}
			}
			.guCiog *{user-select:none;}
			.guCiog{display:flex;-webkit-box-pack:justify;justify-content:space-between;font-family:sofia-pro, sans-serif;font-weight:700;}
			@media (min-width: 1024px){
			.guCiog{font-size:14px;flex-direction:column;direction:ltr;align-items:flex-start;}
			}
			@media (max-width: 1023.98px){
			.guCiog{font-size:14px;flex-direction:column;direction:ltr;align-items:flex-start;}
			}
			@media (max-width: 767.98px){
			.guCiog{font-size:14px;flex-direction:column;direction:ltr;align-items:flex-start;}
			}
			.guCiog *{user-select:none;}
			.bALLdn{display:flex;flex-direction:row-reverse;direction:ltr;}
			.bALLdn > span{margin-right:8px;}
			.bALLdn{display:flex;flex-direction:row-reverse;direction:ltr;}
			.bALLdn > span{margin-right:8px;}
			.ipRrBr{direction:ltr;display:flex;}
			.ipRrBr > :first-child{flex:0 1 0%;}
			@media (min-width: 1024px){
			.ipRrBr{margin-top:8px;-webkit-box-pack:start;justify-content:flex-start;min-width:100%;}
			}
			@media (max-width: 1023.98px){
			.ipRrBr{margin-top:8px;-webkit-box-pack:start;justify-content:flex-start;min-width:100%;}
			}
			@media (max-width: 767.98px){
			.ipRrBr{margin-top:8px;-webkit-box-pack:start;justify-content:flex-start;min-width:100%;}
			}
			.ipRrBr{direction:ltr;display:flex;}
			.ipRrBr > :first-child{flex:0 1 0%;}
			@media (min-width: 1024px){
			.ipRrBr{margin-top:8px;-webkit-box-pack:start;justify-content:flex-start;min-width:100%;}
			}
			@media (max-width: 1023.98px){
			.ipRrBr{margin-top:8px;-webkit-box-pack:start;justify-content:flex-start;min-width:100%;}
			}
			@media (max-width: 767.98px){
			.ipRrBr{margin-top:8px;-webkit-box-pack:start;justify-content:flex-start;min-width:100%;}
			}
			.iEYVXT{text-decoration:none;opacity:1;font-size:14px;font-weight:700;}
			@media (max-width: 1023.98px){
			.iEYVXT{font-size:14px;}
			}
			@media (max-width: 767.98px){
			.iEYVXT{font-size:14px;}
			}
			.iEYVXT{text-decoration:none;opacity:1;font-size:14px;font-weight:700;}
			@media (max-width: 1023.98px){
			.iEYVXT{font-size:14px;}
			}
			@media (max-width: 767.98px){
			.iEYVXT{font-size:14px;}
			}
			.bxXhPq{width:12px;height:12px;box-sizing:border-box;border-radius:50%;display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;border:1px solid rgb(87, 89, 144);margin-right:4px;overflow:visible;background-color:rgb(255, 255, 255);}
			.iObHmE{width:12px;height:12px;box-sizing:border-box;border-radius:50%;display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;border:1px solid rgb(94, 194, 145);margin-right:4px;overflow:hidden;background-color:rgb(255, 255, 255);}
			.guIbQP{width:12px;height:12px;box-sizing:border-box;border-radius:50%;display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;border:1px solid rgb(253, 111, 113);margin-right:4px;overflow:visible;background-color:rgb(255, 255, 255);}
			.bxXhPq{width:12px;height:12px;box-sizing:border-box;border-radius:50%;display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;border:1px solid rgb(87, 89, 144);margin-right:4px;overflow:visible;background-color:rgb(255, 255, 255);}
			.iObHmE{width:12px;height:12px;box-sizing:border-box;border-radius:50%;display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;border:1px solid rgb(94, 194, 145);margin-right:4px;overflow:hidden;background-color:rgb(255, 255, 255);}
			.guIbQP{width:12px;height:12px;box-sizing:border-box;border-radius:50%;display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:center;justify-content:center;border:1px solid rgb(253, 111, 113);margin-right:4px;overflow:visible;background-color:rgb(255, 255, 255);}
			.dDrjOp{width:8px;height:8px;box-sizing:border-box;border-radius:50%;background-color:rgb(253, 111, 113);}
			.dDrjOp{width:8px;height:8px;box-sizing:border-box;border-radius:50%;background-color:rgb(253, 111, 113);}
			.opUld{width:8px;height:10px;transform:rotate(-45deg) translate3d(1.5px, 0px, 0px);box-sizing:border-box;border-radius:50%;background-color:rgb(87, 89, 144);}
			.opUld{width:8px;height:10px;transform:rotate(-45deg) translate3d(1.5px, 0px, 0px);box-sizing:border-box;border-radius:50%;background-color:rgb(87, 89, 144);}
			.klYyjU{width:12px;height:10px;box-sizing:border-box;border-top-left-radius:50%;border-top-right-radius:50%;transform:rotate(-135deg) translate3d(0px, 0px, 0px);background-size:100% 50%;background-image:radial-gradient(100px at 100% 50%, rgb(94, 194, 145), rgb(255, 255, 255));background-repeat:no-repeat;}
			.klYyjU{width:12px;height:10px;box-sizing:border-box;border-top-left-radius:50%;border-top-right-radius:50%;transform:rotate(-135deg) translate3d(0px, 0px, 0px);background-size:100% 50%;background-image:radial-gradient(100px at 100% 50%, rgb(94, 194, 145), rgb(255, 255, 255));background-repeat:no-repeat;}
			.ecgfbt{-webkit-box-align:center;place-items:center stretch;list-style-type:none;margin:0px;padding:8px 32px;display:grid;column-gap:16px;}
			.ecgfbt > *{margin:8px;}
			.ecgfbt > *{box-sizing:border-box;margin:16px 0px 8px;}
			@media (max-width: 1023.98px){
			.ecgfbt{overflow-x:scroll;padding:8px 16px;}
			.ecgfbt > *{padding-right:16px;min-width:200px;max-width:200px;}
			.ecgfbt > :last-child{padding-right:16px;}
			}
			@media (min-width: 1024px){
			.ecgfbt{grid-template-columns:repeat(6, calc((100% - 80px) / 6));}
			.ecgfbt > li:nth-child(1),.ecgfbt > li:nth-child(2),.ecgfbt > li:nth-child(3),.ecgfbt > li:nth-child(4),.ecgfbt > li:nth-child(5),.ecgfbt > li:nth-child(6){display:list-item;}
			}
			@media (min-width: 768px) and (max-width: 1023px){
			.ecgfbt{flex-direction:row;grid-template-columns:unset;}
			.ecgfbt > li:nth-child(1),.ecgfbt > li:nth-child(2),.ecgfbt > li:nth-child(3),.ecgfbt > li:nth-child(4),.ecgfbt > li:nth-child(5),.ecgfbt > li:nth-child(6){display:list-item;}
			}
			@media (max-width: 767px){
			.ecgfbt{flex-direction:row;grid-template-columns:unset;}
			.ecgfbt > li:nth-child(1),.ecgfbt > li:nth-child(2),.ecgfbt > li:nth-child(3),.ecgfbt > li:nth-child(4),.ecgfbt > li:nth-child(5),.ecgfbt > li:nth-child(6){display:list-item;}
			}
			@media (max-width: 1023px){
			.ecgfbt{display:flex;-webkit-box-pack:start;justify-content:flex-start;}
			}
			.ecgfbt{-webkit-box-align:center;place-items:center stretch;list-style-type:none;margin:0px;padding:8px 32px;display:grid;column-gap:16px;}
			.ecgfbt > *{margin:8px;}
			.ecgfbt > *{box-sizing:border-box;margin:16px 0px 8px;}
			@media (max-width: 1023.98px){
			.ecgfbt{overflow-x:scroll;padding:8px 16px;}
			.ecgfbt > *{padding-right:16px;min-width:200px;max-width:200px;}
			.ecgfbt > :last-child{padding-right:16px;}
			}
			@media (min-width: 1024px){
			.ecgfbt{grid-template-columns:repeat(6, calc((100% - 80px) / 6));}
			.ecgfbt > li:nth-child(1),.ecgfbt > li:nth-child(2),.ecgfbt > li:nth-child(3),.ecgfbt > li:nth-child(4),.ecgfbt > li:nth-child(5),.ecgfbt > li:nth-child(6){display:list-item;}
			}
			@media (min-width: 768px) and (max-width: 1023px){
			.ecgfbt{flex-direction:row;grid-template-columns:unset;}
			.ecgfbt > li:nth-child(1),.ecgfbt > li:nth-child(2),.ecgfbt > li:nth-child(3),.ecgfbt > li:nth-child(4),.ecgfbt > li:nth-child(5),.ecgfbt > li:nth-child(6){display:list-item;}
			}
			@media (max-width: 767px){
			.ecgfbt{flex-direction:row;grid-template-columns:unset;}
			.ecgfbt > li:nth-child(1),.ecgfbt > li:nth-child(2),.ecgfbt > li:nth-child(3),.ecgfbt > li:nth-child(4),.ecgfbt > li:nth-child(5),.ecgfbt > li:nth-child(6){display:list-item;}
			}
			@media (max-width: 1023px){
			.ecgfbt{display:flex;-webkit-box-pack:start;justify-content:flex-start;}
			}
			.wtxHh{display:flex;padding:0px 32px;margin-top:0px;}
			@media (max-width: 1023.98px){
			.wtxHh{padding:0px 16px;}
			}
			@media (max-width: 767.98px){
			.wtxHh{flex-direction:column;margin-right:0px;}
			}
			.wtxHh{display:flex;padding:0px 32px;margin-top:0px;}
			@media (max-width: 1023.98px){
			.wtxHh{padding:0px 16px;}
			}
			@media (max-width: 767.98px){
			.wtxHh{flex-direction:column;margin-right:0px;}
			}
			.smrAs{flex:1 1 0%;}
			.smrAs{flex:1 1 0%;}
			.fbbSWQ{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:justify;justify-content:space-between;line-height:32px;margin-bottom:8px;}
			.fbbSWQ a{text-decoration:none;color:rgb(33, 33, 33);}
			.fbbSWQ a:hover{text-decoration:underline;}
			@media (max-width: 1023.98px){
			.fbbSWQ{height:auto;align-items:flex-start;}
			}
			.fbbSWQ{display:flex;-webkit-box-align:center;align-items:center;-webkit-box-pack:justify;justify-content:space-between;line-height:32px;margin-bottom:8px;}
			.fbbSWQ a{text-decoration:none;color:rgb(33, 33, 33);}
			.fbbSWQ a:hover{text-decoration:underline;}
			@media (max-width: 1023.98px){
			.fbbSWQ{height:auto;align-items:flex-start;}
			}
			.jFRJWV{display:flex;-webkit-box-align:center;align-items:center;padding:0px;font-size:32px;color:rgb(0, 0, 0);font-weight:700;margin:0px;}
			.jFRJWV > span{font-family:inherit;cursor:default;color:rgb(0, 0, 0);padding:0px;line-height:inherit;-webkit-box-decoration-break:inherit;}
			.jFRJWV > span:hover{text-decoration:none;}
			@media (max-width: 1023.98px){
			.jFRJWV{-webkit-box-pack:justify;justify-content:space-between;width:100%;font-size:20px;font-weight:700;}
			.jFRJWV > span{line-height:inherit;}
			}
			.jFRJWV{display:flex;-webkit-box-align:center;align-items:center;padding:0px;font-size:32px;color:rgb(0, 0, 0);font-weight:700;margin:0px;}
			.jFRJWV > span{font-family:inherit;cursor:default;color:rgb(0, 0, 0);padding:0px;line-height:inherit;-webkit-box-decoration-break:inherit;}
			.jFRJWV > span:hover{text-decoration:none;}
			@media (max-width: 1023.98px){
			.jFRJWV{-webkit-box-pack:justify;justify-content:space-between;width:100%;font-size:20px;font-weight:700;}
			.jFRJWV > span{line-height:inherit;}
			}
			.cEtWAg{color:rgb(0, 0, 0);margin-left:16px;text-decoration:none!important;}
			.cEtWAg{color:rgb(0, 0, 0);margin-left:16px;text-decoration:none!important;}
			.ftSqEn{text-decoration:none!important;}
			.ftSqEn{text-decoration:none!important;}
			.fQpayy{display:flex;font-size:16px;color:rgb(0, 0, 0);font-weight:700;-webkit-box-align:center;align-items:center;white-space:nowrap;}
			.fQpayy{display:flex;font-size:16px;color:rgb(0, 0, 0);font-weight:700;-webkit-box-align:center;align-items:center;white-space:nowrap;}
			.ieTAeK{color:rgb(0, 0, 0);height:24px;width:24px;}
			.ieTAeK{color:rgb(0, 0, 0);height:24px;width:24px;}
			span,div{font-family:sofia-pro, sans-serif;}
			h2{font-family:henderson-sans-basic, sans-serif;line-height:1.5;}
			/*! CSS Used fontfaces */
			@font-face{font-family:"sofia-pro";src:url("https://use.typekit.net/af/02ad94/00000000000000003b9b46f3/27/l?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n7&v=3") format("woff2"),url("https://use.typekit.net/af/02ad94/00000000000000003b9b46f3/27/d?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n7&v=3") format("woff"),url("https://use.typekit.net/af/02ad94/00000000000000003b9b46f3/27/a?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n7&v=3") format("opentype");font-display:auto;font-style:normal;font-weight:700;font-stretch:normal;}
			@font-face{font-family:"sofia-pro";src:url("https://use.typekit.net/af/ed85d3/00000000000000003b9b46f4/27/l?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i7&v=3") format("woff2"),url("https://use.typekit.net/af/ed85d3/00000000000000003b9b46f4/27/d?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i7&v=3") format("woff"),url("https://use.typekit.net/af/ed85d3/00000000000000003b9b46f4/27/a?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i7&v=3") format("opentype");font-display:auto;font-style:italic;font-weight:700;font-stretch:normal;}
			@font-face{font-family:"sofia-pro";src:url("https://use.typekit.net/af/f5f3eb/00000000000000003b9b46eb/27/l?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n3&v=3") format("woff2"),url("https://use.typekit.net/af/f5f3eb/00000000000000003b9b46eb/27/d?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n3&v=3") format("woff"),url("https://use.typekit.net/af/f5f3eb/00000000000000003b9b46eb/27/a?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n3&v=3") format("opentype");font-display:auto;font-style:normal;font-weight:300;font-stretch:normal;}
			@font-face{font-family:"sofia-pro";src:url("https://use.typekit.net/af/ebb75a/00000000000000003b9b46ec/27/l?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i3&v=3") format("woff2"),url("https://use.typekit.net/af/ebb75a/00000000000000003b9b46ec/27/d?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i3&v=3") format("woff"),url("https://use.typekit.net/af/ebb75a/00000000000000003b9b46ec/27/a?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i3&v=3") format("opentype");font-display:auto;font-style:italic;font-weight:300;font-stretch:normal;}
			@font-face{font-family:"sofia-pro";src:url("https://use.typekit.net/af/4cc789/00000000000000003b9b46ed/27/l?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n4&v=3") format("woff2"),url("https://use.typekit.net/af/4cc789/00000000000000003b9b46ed/27/d?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n4&v=3") format("woff"),url("https://use.typekit.net/af/4cc789/00000000000000003b9b46ed/27/a?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n4&v=3") format("opentype");font-display:auto;font-style:normal;font-weight:400;font-stretch:normal;}
			@font-face{font-family:"sofia-pro";src:url("https://use.typekit.net/af/964ed8/00000000000000003b9b46ee/27/l?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i4&v=3") format("woff2"),url("https://use.typekit.net/af/964ed8/00000000000000003b9b46ee/27/d?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i4&v=3") format("woff"),url("https://use.typekit.net/af/964ed8/00000000000000003b9b46ee/27/a?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i4&v=3") format("opentype");font-display:auto;font-style:italic;font-weight:400;font-stretch:normal;}
			@font-face{font-family:"henderson-sans-basic";src:url("https://use.typekit.net/af/f6abee/00000000000000003b9ae041/27/l?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i4&v=3") format("woff2"),url("https://use.typekit.net/af/f6abee/00000000000000003b9ae041/27/d?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i4&v=3") format("woff"),url("https://use.typekit.net/af/f6abee/00000000000000003b9ae041/27/a?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i4&v=3") format("opentype");font-display:auto;font-style:italic;font-weight:400;font-stretch:normal;}
			@font-face{font-family:"henderson-sans-basic";src:url("https://use.typekit.net/af/8a2d0a/00000000000000003b9ae043/27/l?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n4&v=3") format("woff2"),url("https://use.typekit.net/af/8a2d0a/00000000000000003b9ae043/27/d?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n4&v=3") format("woff"),url("https://use.typekit.net/af/8a2d0a/00000000000000003b9ae043/27/a?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n4&v=3") format("opentype");font-display:auto;font-style:normal;font-weight:400;font-stretch:normal;}
			@font-face{font-family:"henderson-sans-basic";src:url("https://use.typekit.net/af/d654ae/00000000000000003b9ae046/27/l?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i7&v=3") format("woff2"),url("https://use.typekit.net/af/d654ae/00000000000000003b9ae046/27/d?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i7&v=3") format("woff"),url("https://use.typekit.net/af/d654ae/00000000000000003b9ae046/27/a?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=i7&v=3") format("opentype");font-display:auto;font-style:italic;font-weight:700;font-stretch:normal;}
			@font-face{font-family:"henderson-sans-basic";src:url("https://use.typekit.net/af/990c38/00000000000000003b9ae047/27/l?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n7&v=3") format("woff2"),url("https://use.typekit.net/af/990c38/00000000000000003b9ae047/27/d?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n7&v=3") format("woff"),url("https://use.typekit.net/af/990c38/00000000000000003b9ae047/27/a?primer=7cdcb44be4a7db8877ffa5c0007b8dd865b3bbc383831fe2ea177f62257a9191&fvd=n7&v=3") format("opentype");font-display:auto;font-style:normal;font-weight:700;font-stretch:normal;}
			.dblxaZ *{user-select:none;}
			.vGjxz > span{margin-right:8px;}
			.iFxzDu{text-decoration:line-through;opacity:0.75;color:rgb(0, 0, 0);font-size:14px;font-weight:400;}
			@media (max-width: 1023.98px){
			.iFxzDu{font-size:14px;}
			}
			@media (max-width: 767.98px){
			.iFxzDu{font-size:14px;}
			}
		</style>
		<div style="min-height: 450px; max-width: 100%;">
			<div class="ProductsListHeader__Container-wb0oa3-1 wtxHh">
				<div class="ProductsListHeader__Title-wb0oa3-2 smrAs">
					<header class="ProductsListHeader__CategoryHeader-wb0oa3-3 fbbSWQ">
						<h2 class="ProductsListHeader__CategoryTitle-wb0oa3-4 jFRJWV">
							<span>' . esc_html( $atts['title'] ) . '</span>
						</h2>
						<a class="ViewAllLink__CustomLink-ta4buk-0 ftSqEn ProductsListHeader__CustomViewAllLink-wb0oa3-5 cEtWAg" href="' . $view_all . '" style="text-decoration: none;">
							<span class="ViewAllLink__ViewAllText-ta4buk-1 fQpayy">
								<span>View All</span>
								<svg viewBox="0 0 24 24" focusable="false" role="img" fill="currentColor" xmlns="http://www.w3.org/2000/svg" aria-label="View all category gelato products" class="sc-AxiKw fwUcoW ViewAllLink__ChevronRightIcon-ta4buk-2 ieTAeK"><title>View all</title><path d="M10.061 19.061L17.121 12l-7.06-7.061-2.122 2.122L12.879 12l-4.94 4.939z"></path></svg>
							</span>
						</a>
					</header>';

		if ( $atts['text'] ) {
			$html .= '<div class="SeeMore__OuterContainer-sc-110y2wp-0 ghbSJW ProductsListHeader__CategoryDescription-wb0oa3-6 dQnmLi"><p class="SeeMore__HTMLTextContainer-sc-110y2wp-1 kREuIu">' . $atts['text'] . '</p></div>';
		}

		$html .= '
				</div>
			</div>
			<ul data-cy="productListContainer" class="ProductsList__ProductListContainer-sc-1gsh0rs-0 ecgfbt">';

		// Categories
		$categories = array();
		foreach( $products->included as $item ) {
			if ( isset( $item->attributes->id ) ) {
				$item_id = $item->attributes->id;
				$categories[ $item_id ] = array(
					'name' => $item->attributes->name,
					'slug' => $item->attributes->slug,
				);
			}
		}

		// Products
		foreach( $products->data as $product ) {
			$prod_category = $product->relationships->category->data->id;
			$prod_brand    = $product->relationships->brand->data->id;
			$product       = $product->attributes;

			// Prices
			$discount_price = ( isset( $product->unit_prices[0]->discount_price->amount ) ) ? ( (int) $product->unit_prices[0]->discount_price->amount / 100 ) : '';
			$product_price  = ( (int) $product->unit_price->amount / 100 );
			$final_price    = ( $discount_price ) ? $discount_price : $product_price;

			// Product amount
			$product_amount = ( isset( $product->thc->amount ) ) ? $product->thc->amount : '';

			// Create URL
			$product_url = wp_make_link_relative( $product->store_url );

			// Create brand URL
			$brand_url = wp_make_link_relative( $shop_url . 'brands/' . $categories[ $prod_brand ]['slug'] );
			// Build flower type HTML
			$flower_type = '';
			if ( $product->flower_type ) {
				switch ( $product->flower_type ) {
					case 'Hybrid':
						$ft_icon = WP_TYMBER_SHOP_URL . '/public/images/Hybrid.svg';
						break;
					case 'Sativa':
						$ft_icon = WP_TYMBER_SHOP_URL . '/public/images/Sativa.svg';
						break;
					case 'Indica':
						$ft_icon = WP_TYMBER_SHOP_URL . '/public/images/Indica.svg';
						break;
				}

				$flower_type = '<div class="sc-fzoMdx kJrSSp product-card__flower-type-indicator-container" data-keep-cart="true">
					<div class="sc-fzpkqZ fPuZnD flower-type-indicator__container" data-keep-cart="true">
						<div overflow="visible" class="flowerTypeIcons__TypeIndicatorOuterCircle-sc-1ahluul-0 bxXhPq">
							<div class="flowerTypeIcons__IndicaTypeIndicatorInnerCircle-sc-1ahluul-2 opUld" style="background: url(' . $ft_icon . ');transform: inherit !important; width: 12px; height: 12px; background-position: center;"></div>
						</div>
						<span class="sc-fzoYHE cAydmo flower-type-indicator__name" data-keep-cart="true">' . $product->flower_type . '</span>
					</div>
				</div>';
			}

			$html .= '<li>
					<div class="sc-fzomuh fueCwg product-card__header-container" data-keep-cart="true">
						<div class="sc-fzoJus lnODeW product-card__container" data-keep-cart="true">
							<div mode="big" class="sc-fzoVTD neoAm product-card__image-container" data-keep-cart="true">
								<a href="' . $product_url . '" style="text-decoration: none;">
									<img alt="' . $product->name . '" class="sc-fzpisO bNgEec product-card__image" height="175" src="' . $product->main_image . '">
									' . $flower_type . '
								</a>
							</div>
							<div mode="big" class="sc-fznXWL bJVrMZ product-card__content" data-keep-cart="true">
								<div class="sc-fznyYp CSvot product-card__info" data-keep-cart="true">
									<div class="sc-fzoydu bUJenD product-card__potency-tags-container" data-keep-cart="true">
										<div class="sc-fzoJMP ihGa-DG potency-tag potency-tag__container" data-keep-cart="true">THC: ' . $product_amount . '%</div>
									</div>
									<div class="sc-fzqzlV gMJRj">
										<a href=" ' . $brand_url . '">
											<span class="sc-fzqLLg kRdiPk product-card__brand-name" data-keep-cart="true">' . $categories[ $prod_brand ]['name'] . '</span>
										</a>
									</div>
									<a href="' . $product_url . '" style="text-decoration: none;">
										<span mode="big" class="sc-fzokvW lloAGz product-card__name" data-keep-cart="true">' . $product->name . '</span>
									</a>
									<div class="sc-fzplgP bHmBtJ product-card__aligned-information-container" data-keep-cart="true">
										<span class="sc-fzoxnE dbOBBq product-card__product-size" data-keep-cart="true">' . $product->size->display_text . '</span>
									</div>
								</div>
								<div class="sc-fznLxA fytMEJ product-card__actions" data-keep-cart="true">
									<div class="sc-prOVx guCiog cart-icon-actions cart-icon-actions__container" data-keep-cart="true">
										<div class="sc-qQmou bALLdn cart-icon-actions cart-icon-actions__price-container" data-keep-cart="true">';

										if ( $discount_price ) {
											$html .= '<span class="CartIconActions__PriceText-sc-1fkk08z-3 iFxzDu cart-icon-actions cart-icon-actions__price-text" data-keep-cart="true">$ ' . $product_price . '</span>';
										}
										$html .= '<span class="sc-pAZqv iEYVXT cart-icon-actions cart-icon-actions__price-text" data-keep-cart="true">$' . $final_price . '</span>
										</div>
										<a href="' . $product_url . '" style="text-decoration: none;"><div class="sc-qYiqT ipRrBr cart-icon-actions cart-icon-buttons__container" data-keep-cart="true">
											<div class="sc-AxheI VKSrw">
												<a href="' . $product_url . '"><div role="button" aria-pressed="false" class="sc-pZBmh xzbAw cart-icon-actions cart-icon-actions__actions" data-keep-cart="true">
													<svg viewBox="0 0 24 24" height="24px" width="24px" aria-hidden="true" focusable="false" fill="currentColor" xmlns="http://www.w3.org/2000/svg" color="#ffffff" data-keep-cart="true" class="sc-AxjAm dQgIel sc-fzpans kuHuRJ"><g data-name="Layer 2"><g data-name="shopping-cart"><path d="M21.08 7a2 2 0 00-1.7-1H6.58L6 3.74A1 1 0 005 3H3a1 1 0 000 2h1.24L7 15.26A1 1 0 008 16h9a1 1 0 00.89-.55l3.28-6.56A2 2 0 0021.08 7zm-4.7 7H8.76L7.13 8h12.25z"></path><circle cx="7.5" cy="19.5" r="1.5"></circle><circle cx="17.5" cy="19.5" r="1.5"></circle></g></g></svg>
												</div></a>
											</div>
										</div></a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</li>';
		}

		$html .='</ul>
		</div>';

		return $html;
	}

	/**
	 * Generate brands shortcode
	 *
	 * @since    1.0.0
	 * @param    array $atts     arguments to shortcode
	 */
	public function tymber_block_brands_shortcode( $atts ) {
		$atts = shortcode_atts(
			array(
				'title' => '',
				'limit' => '',
				'store' => '',
			),
			$atts
		);

		if ( ! $this->api_token ) {
			return __( 'A store ID was not specified on Tymber Shop settings.', 'wp-tymber-shop' );
		}

		if ( ! $atts['store'] ) {
			$store_id = $this->store_id;
		} else {
			$store_id = $this->get_store_id( $atts['store'] );
		}

		$brands = $this->get_tymber_brands( $store_id, $atts['limit'] );

		if ( $brands ) {

			$html  = '<style>
						.wtxHh {
							display: flex;
							padding: 0px 32px;
							margin-top: 0px;
						}
						.smrAs {
							flex: 1 1 0%;
						}
						.fbbSWQ {
							display: flex;
							-webkit-box-align: center;
							align-items: center;
							-webkit-box-pack: justify;
							justify-content: space-between;
							line-height: 32px;
							margin-bottom: 8px;
						}
						.jFRJWV {
							display: flex;
							-webkit-box-align: center;
							align-items: center;
							padding: 0px;
							font-size: 32px;
							color: rgb(0, 0, 0);
							font-weight: 700;
							margin: 0px;
						}
						.jFRJWV > span {
							font-family: inherit;
							cursor: default;
							color: rgb(0, 0, 0);
							padding: 0px;
							line-height: inherit;
							-webkit-box-decoration-break: inherit;
						}
						ul.wl_brands_list {
						  display: flex;
						  justify-content: space-between;
						  list-style-type: none;
						  padding: 0;
						}

						.wl_brands_list li {
						  flex: 1;
						  margin: 10px;
						  background-color: #fff;
						  border: 1px solid #eee;
						  border-radius: 15px;
						}
						.wl_brands_list li img {
							max-width: 200px;
							height: auto;
							margin: auto;
						}
						.wl_brands_list li span {
							text-align: center;
						}
						.wl_brands_list li .wrapper {
							display: flex;
							justify-content: center;
							width:100%;
							min-height: 240px;
							max-height: 240px;
						}
						.wl_brands_list .brand_title {
							width:100%;
							margin-bottom: 20px;
							text-align:center;
							color: #363636;
							font-weight: 500;
							font-family: inherit;
						}
						@media screen and (max-width: 767px) {
						  .wl_brands_list {
							display: block !important;
						  }
						}
					</style>';

			$html .= '<div style="min-height: 450px; max-width: 100%;">
			<div class="ProductsListHeader__Container-wb0oa3-1 wtxHh">
				<div class="ProductsListHeader__Title-wb0oa3-2 smrAs">
					<header class="ProductsListHeader__CategoryHeader-wb0oa3-3 fbbSWQ">
						<h2 class="ProductsListHeader__CategoryTitle-wb0oa3-4 jFRJWV">
							<span>' . esc_html( $atts['title'] ) . '</span>
						</h2>
					</header>
				</div>
			</div>
			<div>';

			$brands_data = $brands->data;
			$chunks      = is_array( $brands_data ) ? array_chunk( $brands_data, 4 ) : '';
			$num_brands  = 0;

			foreach ( $chunks as $chunk ) {
				$html .= '<ul class="wl_brands_list">';

				foreach ( $chunk as $item ) {
					if ( $atts['limit'] == $num_brands ) {
						break;
					}

					$brand_attr  = $item->attributes;
					$brand_image = $brand_attr->logo_url;
					$brand_name  = $brand_attr->name;
					$brand_url   = wp_make_link_relative( $brand_attr->store_url );
					$html .= '<li><a href="' . $brand_url . '"><div class="wrapper"><img src="' . $brand_image . '"></div><div class="brand_title"><span>' . $brand_name . '</span></div></a></li>';
					$num_brands++;
				}
				$html .= '</ul>';
			}

			$html .= '</div></div>';
			return $html;
		} else {
			return __( 'No brands to show.', 'wp-tymber-shop' );
		}
	}

	/**
	 * Get products from Tymber API
	 *
	 * @since    1.0.0
	 */
	public function get_tymber_data( $store_id, $filter = '', $order = '', $limit = '', $delivery_type = '' ) {
		// Filter
		$query_filter = '';
		if ( $filter ) {
			$key          = strstr( $filter, '=', true );
			$query_parts  = explode( '=', $filter );
			$values       = explode( ',', $query_parts[1] );
			foreach ( $values as $value ) {
				$query_filter .= $key . "[]=$value&";
			}
			$query_filter = rtrim( $query_filter, '&' );
		}

		// Sort
		$query_sort = ( $order ) ? "order=$order" : '';

		// Limit
		$query_limit = ( $limit ) ? $limit : '6';

		// Delivery Type
		$query_delivery_type = ( $delivery_type ) ? 'delivery_type='.$delivery_type : '';

		$response = wp_remote_get(
			$this->api_url . "/products?$query_delivery_type&limit=$query_limit&$query_filter&$query_sort",
			array(
				'headers' => array(
					'X-Store' => $store_id
				)
			)
		);

		if ( ! is_wp_error( $response ) ) {
			$body = wp_remote_retrieve_body($response);
			return json_decode( $body );
		} else {
			$error_message = $response->get_error_message();
			return json_decode( $error_message );
		}
	}

	/**
	 * Get brands from Tymber API
	 *
	 * @since    1.0.0
	 */
	public function get_tymber_brands( $store_id, $limit = '' ) {
		// Limit
		$query_limit = '';
		if ( $limit ) {
			$query_limit = '?limit=' . $limit;
		}

		$response = wp_remote_get(
			$this->api_url . "/products/brands" . $query_limit,
			array(
				'headers' => array(
					'X-Store' => $store_id
				)
			)
		);

		if ( ! is_wp_error( $response ) ) {
			$body = wp_remote_retrieve_body( $response );
			return json_decode( $body );
		} else {
			$error_message = $response->get_error_message();
			return json_decode( $error_message );
		}
	}

	/**
	 * Get the shop base path from Tymber API
	 *
	 * @since    1.0.0
	 */
	public function get_the_shop_url($store_id) {
		$response = wp_remote_get(
			$this->api_url . "/store/site/",
			array(
				'headers' => array(
					'X-Store' => $store_id
				)
			)
		);

		if ( ! is_wp_error( $response ) ) {
			$body = wp_remote_retrieve_body($response);
			$body = json_decode( $body );
			return $body->data->attributes->url;
		} else {
			$error_message = $response->get_error_message();
			return json_decode( $error_message );
		}
	}

	/**
	 * Get data from Tymber API
	 *
	 * @since    1.0.0
	 */
	public function get_tymber_banners( $store_id, $limit = '' ) {
		// Limit
		$query_limit = '';
		if ( $limit ) {
			$query_limit = '?limit=' . $limit;
		}

		$response = wp_remote_get(
			$this->api_url . "/store/site/promotional-banners" . $query_limit,
			array(
				'headers' => array(
					'X-Store' => $store_id
				)
			)
		);

		if ( ! is_wp_error( $response ) ) {
			$body = wp_remote_retrieve_body( $response );
			return json_decode( $body );
		} else {
			$error_message = $response->get_error_message();
			return json_decode( $error_message );
		}
	}

	/**
	 * Generate random string
	 *
	 * @since    1.0.0
	 */
	public function generate_random_string( $length = 10 ) {
		$characters        = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$characters_length = strlen( $characters );
		$random_string      = '';
		for ( $i = 0; $i < $length; $i++ ) {
			$random_string .= $characters[ random_int( 0, $characters_length - 1 ) ];
		}
		return $random_string;
	}

	/**
	 * Enqueue_scripts on frontend
	 *
	 * @since    1.0.0
	 */
	public function tymber_enqueue_scripts() {
		// Check if jQuery is loaded
		if ( ! wp_script_is( 'jquery', 'enqueued' ) && ! wp_script_is( 'jquery', 'done' ) ) {
			wp_enqueue_script( 'jquery' );
		}

		wp_enqueue_script( 'wp-tymber-shop-public', WP_TYMBER_SHOP_URL . 'public/js/wp-tymber-shop-public.js', array(), WP_TYMBER_SHOP_VERSION );

		wp_localize_script( 'wp-tymber-shop-public', 'wp_tymber',
			array(
				'ajaxurl' => admin_url( 'admin-ajax.php' ),
			)
		);

		wp_enqueue_script( 'wp-tymber-shop-slick', '//cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js', array(), '' );

		wp_enqueue_style( 'wp-tymber-shop-public-css', WP_TYMBER_SHOP_URL . 'public/css/wp-tymber-shop-public.css' );
		wp_enqueue_style( 'wp-tymber-slick-css', '//cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css' );
		wp_enqueue_style( 'wp-tymber-slick-theme-css', '//cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css' );
		wp_enqueue_style( 'wp-tymber-slick-css', '//cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css' );
	}

	/**
	 * Get shop link dynamically
	 *
	 * @since    1.0.0
	 */
	public function get_dynamic_part( $full_url ) {
		$parsed_url   = parse_url( $full_url );
		$dynamic_part = isset( $parsed_url['path'] ) ? $parsed_url['path'] : '';

		if ( isset( $parsed_url['query'] ) ) {
			$dynamic_part .= '?' . $parsed_url['query'];
		}

		return $dynamic_part;
	}

	/**
	 * Get store ID
	 *
	 * @since    1.0.0
	 */
	public function get_store_id( $store_name ) {
		$store_ids = get_option( '_tymber-store_ids' );

		if ( $store_ids ) {
			foreach( $store_ids as $store ) {
				if ( $store->shop_store_title === $store_name ) {
					$store_id = $store->shop_store_id;
				}
			}
		} else {
			$store_id = $this->store_id;
		}

		if ( ! $store_id ) {
			$store_id = $this->store_id;
		}

		return $store_id;
	}

	public function tv2_lite_remove_redirect_guess_404_permalink( $redirect_url ) {
		if ( is_404() && ! isset( $_GET['p'] ) ) {
			return false;
		}

		return $redirect_url;
	}

}
