<?php

/**
 * Tymber WordPress plugin that allows you to embed our shop on your website
 *
 * @link              https://tymber.me
 * @since             1.0.2
 * @package           Wp_Tymber_Shop
 *
 * @wordpress-plugin
 * Plugin Name:       WP Tymber Shop
 * Plugin URI:        https://tymber.me/shop/
 * Description:       Tymber Shop - advanced online shopping experience for cannabis pick-ups & deliveries.
 * Version:           1.0.2
 * Author:            Tymber
 * Author URI:        https://tymber.me
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wp-tymber-shop
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.2 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'WP_TYMBER_SHOP_VERSION', '1.0.2' );

/**
 * The plugin slug.
 */
define( 'WP_TYMBER_SHOP_DIR', plugin_dir_path( __FILE__ ) );
define( 'WP_TYMBER_SHOP_URL', plugin_dir_url( __FILE__ ) ) ;

/**
 * The Tymber URL API
 */
define( 'WP_TYMBER_SHOP_TYMBER_API', get_tymber_url() );
define( 'WP_TYMBER_SHOP_TYMBER_URL', get_tymber_url( '', true ) );

/**
 * Plugin Get plugin env
 *
 * @return string
 * @since 0.1.0
 */
function wp_tymber_shop_get_env()
{
	if ( defined( 'WP_ENV' ) && ! empty( WP_ENV ) ) {
		switch (WP_ENV) {
			case 'dev':
			case 'development':
			case 'staging':
				return 'development';
			case 'local':
				return 'local';
			case 'production':
			case 'prod':
			default:
				return 'production';
		}
	}

	return 'production';
}

/**
 * Get Tymber URL
 */
function get_tymber_url( $version = 'v1', $no_api = false )
{
	$url = 'https://blaze-wp-server.tymber.io';

	if ( function_exists( 'wp_tymber_shop_get_env' ) ) {
		$wp_env = wp_tymber_shop_get_env();
		if ( 'development' === $wp_env ) {
			$url = 'https://tymber.dev.widgilabs-sites.com';
		}
		if ( 'local' === $wp_env ) {
			$url = 'http://tymberserver.local';
		}
	}

	if ( $no_api ) {
		return $url;
	}

	$namespace = '/wp-json/tymber/';
	$api       = $url . $namespace . $version;

	return $api;
}

/**
 * The core plugin class that is used to define internationalisation,
 * admin-specific hooks, and public-facing site hooks.
 */
require WP_TYMBER_SHOP_DIR . 'includes/class-wp-tymber-shop.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.2
 */
function run_wp_tymber_shop() {
	$plugin = new Wp_Tymber_Shop();
	$plugin->run();
}
run_wp_tymber_shop();

require WP_TYMBER_SHOP_DIR. '/plugin-update-checker/plugin-update-checker.php';
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

$myUpdateChecker = PucFactory::buildUpdateChecker(
	WP_TYMBER_SHOP_TYMBER_URL . '/wp-content/plugins/wp-tymber-server/plugin.json',
	__FILE__, //Full path to the main plugin file or functions.php.
	'wp-tymber-shop'
);